% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_dep.R
\name{stat_dep}
\alias{stat_dep}
\title{Computes the Kendall's taus and Spearman's rho for tests of randomness}
\usage{
stat_dep(x, y)
}
\arguments{
\item{x}{vector of length n}

\item{y}{vector of length n}
}
\value{
\item{tau}{Kendall's taus for lags 1:lag}

\item{rho}{Spearman's rhos for lags 1:lag}

\item{s2}{estimated variance of Spearman's rho}
}
\description{
This function Computes the Kendall's taus and Spearman's rho for tests of independence used in EstDep
}
\examples{
x <- SimAR1Poisson(c(5,0.2),100)
y <- SimAR1Poisson(c(5,0.2),100)
out <- stat_dep(x,y)

}
\references{
Genest, Neslehova, & Remillard (2017). Asymptotic behavior of the empirical multilinear copula process under broad conditions
}
\keyword{internal}
