% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cluster_impute}
\alias{cluster_impute}
\title{Imputation using Cluster Means}
\usage{
cluster_impute(X, clusters)
}
\arguments{
\item{X}{An \eqn{n} x \eqn{d} matrix or data frame where \eqn{n} is the number of
observations and \eqn{d} is the number of columns or variables. Alternately,
\code{X} can be a vector of \eqn{n} observations.}

\item{clusters}{A numeric vector containing cluster memberships. Every integer
from 1 to \code{G} must be present.}
}
\value{
A complete data matrix with missing values imputed accordingly.
}
\description{
Replace missing values within each cluster with the corresponding cluster mean
obtained by other observed values. In other words, a separate mean imputation
is applied for every cluster.
}
\examples{

X <- matrix(nrow = 6, ncol = 3, byrow = TRUE, c(
  NA,  2,  2,
   3, NA,  5,
   4,  3,  2,
  NA, NA,  3,
   7,  2, NA,
  NA,  4,  2
))

cluster_impute(X, clusters = c(1, 1, 1, 2, 2, 2))

}
