% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixtureMissing.R
\name{summary.MixtureMissing}
\alias{summary.MixtureMissing}
\title{Summary for Mixture Missing}
\usage{
\method{summary}{MixtureMissing}(object, ...)
}
\arguments{
\item{object}{A \code{MixtureMissing} object.}

\item{...}{Arguments to be passed to methods, such as graphical parameters.}
}
\value{
No return value, called to summarize the fitted model's results
}
\description{
Summarizes main information regarding a \code{MixtureMissing} object.
}
\details{
Information includes the model used to fit the data set, initialization
  method, clustering table, total outliers, outliers per cluster, mixing proportions,
  component means and variances, final log-likelihood value, information criteria.
}
\examples{

#++++ With no missing values ++++#

X <- auto[, c('horsepower', 'highway_mpg', 'price')]
mod <- MCNM(X, G = 2, init_method = 'kmedoids', max_iter = 10)
# summary(mod)

#++++ With missing values ++++#

X <- auto[, c('normalized_losses', 'horsepower', 'highway_mpg', 'price')]
mod <- MCNM(X, G = 2, init_method = 'kmedoids', max_iter = 10)
summary(mod)

}
