% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.vcf.R
\name{get.vcf}
\alias{get.vcf}
\title{Generate vcf-file}
\usage{
get.vcf(
  population,
  path = NULL,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  chromosomen = "all",
  non.genotyped.as.missing = FALSE,
  use.id = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{path}{Location to save vcf-file}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{chromosomen}{Beschraenkung des Genotypen auf bestimmte Chromosomen (default: 1)}

\item{non.genotyped.as.missing}{Set to TRUE to replaced non-genotyped entries with "./."}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names}
}
\value{
VCF-file for in gen/database/cohorts selected individuals
}
\description{
Generate a vcf-file for selected groups and chromosome
}
\examples{
data(ex_pop)
data(ex_pop)
\donttest{
file_path <- tempdir()
get.vcf(path=file_path, ex_pop, gen=2)
file.remove(paste0(file_path, ".vcf"))
}
}
