% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/priorKnowledge.R
\name{getCoefficients}
\alias{getCoefficients}
\title{Get the Coefficients}
\usage{
getCoefficients(fPI, rangeNewPriorData, fD, data, domain, coeffversion)
}
\arguments{
\item{fPI}{The fitted function to the prior data of class \code{"motbf"}.}

\item{rangeNewPriorData}{An array of length two with the new domain of the prior function.}

\item{fD}{The fitted function to the original data of class \code{"motbf"}.}

\item{data}{A \code{"numeric"} array which contains the values to fit.}

\item{domain}{A \code{"numeric"} array with the limits where defining the data function.}

\item{coeffversion}{A \code{"numeric"} value between \code{1--4} which contains the used version for computing the coefficients in the linear
opinion pool to combine the prior function and the data function. By default \code{coeffversion = "4"} is used, so the combination
depends on the goodness of the model versus another random positive MoTBF model.}
}
\value{
A \code{"numeric"} value of length 2 giving the coefficients which are the weigth of the two function to combine.
}
\description{
Compute the coefficients for the linear opinion pool
}
\details{
\code{coeffversion} can be:
\code{"1"} coef1 and coef2 are the sum of the probabilities of one of the function over the sum of all probabilities, respectively;
\code{"2"} coef1 and coef2 are the solution of a linear optimization problem which tries to maximize the sum 1 for each row of probabilities;
\code{"3"} coef1 and coef2 are the difference of the log-likelihood of the evaluated model and a random uniform model over the sum of both differences, respectively;
\code{"4"} coef1 and coef2 are the difference of the log-likelihood of the evaluated model and a ramdom positive MoTBF model over the sum of both differences, respectively.
}
\examples{
## Data
X <- rnorm(15)

## Prior Data
priordata <- rnorm(5000)

## Learning
confident <- 5
type <- "MOP"
f <- learnMoTBFpriorInformation(priorData = priordata, data = X, s = confident,
POTENTIAL_TYPE = type)
attributes(f)

## Coefficients: linear opinion pool
getCoefficients(fPI = f$priorFunction, rangeNewPriorData = f$domain, fD = f$dataFunction,
data = X, domain = range(X), coeffversion = 4)

getCoefficients(fPI = f$priorFunction, rangeNewPriorData = f$domain, fD = f$dataFunction,
data = X, domain = range(X), coeffversion = 1)

getCoefficients(fPI = f$priorFunction, rangeNewPriorData = f$domain, fD = f$dataFunction,
data = X, domain = range(X), coeffversion = 3)

getCoefficients(fPI = f$priorFunction, rangeNewPriorData = f$domain, fD = f$dataFunction,
data = X, domain = range(X), coeffversion = 2)
}
\seealso{
\link{learnMoTBFpriorInformation}
}

