% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint.R
\name{nVariables}
\alias{nVariables}
\title{Number of Variables in a Joint Function}
\usage{
nVariables(P)
}
\arguments{
\item{P}{An \code{"motbf"} object or a \code{"jointmotbf"} object.}
}
\value{
A \code{"character"} vector with the names of variables of the function.
}
\description{
Compute the number of variables which are in a 'jointmotbf' object.
}
\examples{

# 1. EXAMPLE
## Generate a dataset
data <- data.frame(X1 = rnorm(100), X2 = rnorm(100))

## Joint function
dim <-c(3,2)
param <- parametersJointMoTBF(data, dimensions = dim)
P <- jointMoTBF(param)
P

## Variables
nVariables(P)

##############################################################################
## MORE EXAMPLES #############################################################
##############################################################################
\donttest{
## Generate a dataset
data <- data.frame(X1 = rnorm(100), X2 = rnorm(100), X3 = rnorm(100))

## Joint function
dim <- c(2,1,3)
param <- parametersJointMoTBF(data, dimensions = dim)
P <- jointMoTBF(param)

## Variables
nVariables(P)
}
}
