% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{device_flow_auth}
\alias{device_flow_auth}
\title{Authenticate using device flow}
\usage{
device_flow_auth(endpoint, client_id, scopes = c("openid", "offline_access"))
}
\arguments{
\item{endpoint}{An \code{\link{oauth_endpoint}} with a device endpoint
specified in it}

\item{client_id}{The client ID for which the token should be obtained}

\item{scopes}{the requested scopes, default to
\code{c("openid", "offline_access")}}
}
\value{
The credentials retrieved from the token endpoint
}
\description{
Get an ID token using the
\href{https://tools.ietf.org/html/rfc8628}{OpenIDConnect Device Flow}.
}
\examples{
\dontrun{
endpoint <- discover("https://auth.molgenis.org")
device_flow_auth(endpoint, "b396233b-cdb2-449e-ac5c-a0d28b38f791")
}

}
