\name{tfourier.i}
\alias{tfourier.i}


\title{
Calculates inverse tangent angle Fourier analysis.
}

\description{
\code{tfourier.i} uses the inverse tangent angle Fourier transformation to calculate a shape, when given a list with Fourier coefficients, typically obtained computed with \link{tfourier}.
}

\usage{
tfourier.i(tf, nb.h, nb.pts = 300, force2close = FALSE, rescale =TRUE, perim = 2 * pi, thetao = 0)
}

\arguments{
  \item{tf}{a list with ao, an and bn components, typically as returned by tfourier}
  \item{nb.h}{\code{integer}. The number of harmonics to calculate/use}
  \item{nb.pts}{\code{integer}. The number of points to calculate}
  \item{force2close}{\code{logical}. Whether to force the outlines calculated to close (see \link{coo.force2close}).}
  \item{rescale}{\code{logical}. Whether to rescale the points calculated so that their perimeter equals \code{perim}.}
  \item{perim}{The perimeter length to rescale shapes.}
  \item{thetao}{\code{numeric}. Radius angle to the reference (in radians)}
}

\details{
See \link{tfourier} for the mathematical background.
}

\value{
A list with components:
	\item{x }{\code{vector} of \code{x}-coordinates.}
	\item{y }{\code{vector} of \code{y}-coordinates.}
	\item{phi }{\code{vector} of interpolated changes on the tangent angle.}
	\item{angle }{\code{vector} of position on the perimeter (in radians).}
}

\references{
Zahn CT, Roskies RZ. 1972. Fourier Descriptors for Plane Closed Curves. \emph{IEEE Transactions on Computers} \bold{C-21}: 269-281.

Claude, J. (2008) \emph{Morphometrics with R}, Use R! series, Springer 316 pp.
}

\seealso{
\link{tfourier} for the reverse operation and also \code{tfourier.shape}. \link{l2m}, \link{coeff.split} may be useful.
}

\examples{
data(bot)
tfourier(bot@coo[[1]], 24)
tfourier.shape()
}


\keyword{tangent angle Fourier analysis}


