% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-domesticplotters.R
\name{Ptolemy}
\alias{Ptolemy}
\title{Ptolemaic ellipses and illustration of efourier}
\usage{
Ptolemy(coo, t = seq(0, 2 * pi, length = 7)[-1], nb.h = 3, nb.pts = 360,
  palette = col_heat, zoom = 5/4, legend = TRUE, ...)
}
\arguments{
\item{coo}{a matrix of (x; y) coordinates}

\item{t}{A \code{vector} af angles (in radians) on which to display ellipses}

\item{nb.h}{\code{integer}. The number of harmonics to display}

\item{nb.pts}{\code{integer}. The number of points to use to display shapes}

\item{palette}{a color palette}

\item{zoom}{numeric a zoom factor for \link{coo_plot}}

\item{legend}{\code{logical}. Whether to plot the legend box}

\item{...}{additional parameters to feed \link{coo_plot}}
}
\description{
Calculate and display Ptolemaic ellipses which illustrates
intuitively the principle behing elliptical Fourier analysis.
}
\examples{
data(shapes)
cat <- shapes[4]
Ptolemy(cat, main="An EFT cat")
}
\references{
This method has been inspired by the figures found in the followings papers.
Kuhl FP, Giardina CR. 1982. Elliptic Fourier features of a closed contour.
 \emph{Computer Graphics and Image Processing} \bold{18}: 236-258.
Crampton JS. 1995. Elliptical Fourier shape analysis of fossil bivalves:
some practical considerations. \emph{Lethaia} \bold{28}: 179-186.
}
\seealso{
An intuitive explanation of elliptic Fourier analysis can be found in
the \bold{Details} section of the \link{efourier} function.

exemplifying functions
}

