% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-utilities.R
\name{def_ldk}
\alias{def_ldk}
\title{Defines new landmarks on Out and Opn objects}
\usage{
def_ldk(Coo, nb.ldk)
}
\arguments{
\item{Coo}{an Out or Opn object}

\item{nb.ldk}{the number of landmarks to define on every shape}
}
\value{
an Out or an Opn object with some landmarks defined
}
\description{
Helps to define landmarks on a \code{Coo} object.
The number of landmarks must be specified and rows indices that
correspond to the nearest points clicked on every outlines are
stored in the \code{$ldk} slot of the \code{Coo} object.
}
\examples{
\dontrun{
data(bot)
bot <- bot[1:5] # to make it shorter to try
# click on 3 points, 5 times.
# Don't forget to save the object returned by def_ldk...
bot2 <- def_ldk(bot, 3)
stack(bot2)
bot2$ldk
}
}
\seealso{
Other ldk/slidings methods: \code{\link{add_ldk}},
  \code{\link{def_slidings}}, \code{\link{get_ldk}},
  \code{\link{get_slidings}}, \code{\link{slidings_scheme}}
}

