% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-domesticplotters.R
\name{Ntable}
\alias{Ntable}
\title{Plots confusion matrix of sample sizes within $fac}
\usage{
Ntable(x, fac1, fac2 = fac1, rm0 = FALSE)
}
\arguments{
\item{x}{any object with a $fac slot (Coo, Coe, PCA, etc.)}

\item{fac1}{the name or id of the first factor}

\item{fac2}{the name of id of the second factor}

\item{rm0}{logical whether to print zeros}
}
\value{
a ggplot2 object
}
\description{
An utility that plots a confusion matrix of sample size (or a barplot)
for every object with a $fac. Useful to visually how large are sample sizes,
how (un)balanced are designs, etc.
}
\examples{
data(olea)
Ntable(olea, "var")
Ntable(olea, "domes", "var")
gg <- Ntable(olea, "domes", "var", rm0 = TRUE)
gg
library(ggplot2)
gg + coord_equal()
gg + scale_fill_gradient(low="green", high = "red")
gg + coord_flip()
}
\seealso{
Other plotting functions: \code{\link{conf_ell}},
  \code{\link{coo_arrows}}, \code{\link{coo_draw}},
  \code{\link{coo_listpanel}}, \code{\link{coo_lolli}},
  \code{\link{coo_plot}}, \code{\link{coo_ruban}},
  \code{\link{ldk_chull}}, \code{\link{ldk_confell}},
  \code{\link{ldk_contour}}, \code{\link{ldk_labels}},
  \code{\link{ldk_links}}, \code{\link{plot_devsegments}}
}
