% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_slidedirection}
\alias{coo_slidedirection}
\title{Slides coordinates in a particular direction}
\usage{
coo_slidedirection(coo, direction, center, id)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates or a \code{list}, or any \link{Coo} object.}

\item{direction}{\code{character} among \code{'N'} (by default), \code{'S'}, \code{'E'}, or \code{'W'}.}

\item{center}{\code{logical} whether to center or not before sliding}

\item{id}{\code{numeric} whether to return the id of the point or the slided shapes}
}
\value{
a \code{matrix} of (x; y) coordinates, or a \link{Coo} object.
}
\description{
Shapes are centered and then, according to direction, the point northwards, southwards,
eastwards or westwards the centroid, becomes the first point with \link{coo_slide}.
}
\examples{
b <- coo_rotate(bot[1], pi/6) # dummy example just to make it obvious
coo_plot(b) # not the first point
coo_plot(coo_slidedirection(b, 'N'))
coo_plot(coo_slidedirection(b, 'E'))
coo_plot(coo_slidedirection(b, 'W'))
coo_plot(coo_slidedirection(b, 'S'))

# on Coo objects
stack(bot)
stack(coo_slidedirection(bot, 'E'))

}
\seealso{
Other sliding functions: \code{\link{coo_slidegap}},
  \code{\link{coo_slide}}

Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_bookstein}},
  \code{\link{coo_boundingbox}},
  \code{\link{coo_calliper}}, \code{\link{coo_centdist}},
  \code{\link{coo_center}}, \code{\link{coo_centpos}},
  \code{\link{coo_chull_onion}}, \code{\link{coo_close}},
  \code{\link{coo_down}}, \code{\link{coo_dxy}},
  \code{\link{coo_extract}}, \code{\link{coo_flipx}},
  \code{\link{coo_force2close}},
  \code{\link{coo_interpolate}}, \code{\link{coo_jitter}},
  \code{\link{coo_left}}, \code{\link{coo_nb}},
  \code{\link{coo_perimcum}}, \code{\link{coo_perimpts}},
  \code{\link{coo_perim}}, \code{\link{coo_rev}},
  \code{\link{coo_right}}, \code{\link{coo_rotatecenter}},
  \code{\link{coo_rotate}}, \code{\link{coo_samplerr}},
  \code{\link{coo_sample}}, \code{\link{coo_scalex}},
  \code{\link{coo_scale}}, \code{\link{coo_shearx}},
  \code{\link{coo_slice}}, \code{\link{coo_slidegap}},
  \code{\link{coo_slide}}, \code{\link{coo_smoothcurve}},
  \code{\link{coo_smooth}}, \code{\link{coo_template}},
  \code{\link{coo_trans}}, \code{\link{coo_trimbottom}},
  \code{\link{coo_trimtop}}, \code{\link{coo_trim}},
  \code{\link{coo_up}}, \code{\link{is_clockwise}},
  \code{\link{is_closed}},
  \code{\link{is_equallyspacedradii}}
}
