% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-domesticplotters.R
\name{coo_listpanel}
\alias{coo_listpanel}
\title{Plots sets of shapes.}
\usage{
coo_listpanel(coo.list, dim, byrow = TRUE, fromtop = TRUE, cols, borders,
  poly = TRUE, points = FALSE, points.pch = 3, points.cex = 0.2,
  points.col = "#333333", ...)
}
\arguments{
\item{coo.list}{A \code{list} of coordinates}

\item{dim}{A \code{vector} of the form \code{(nb.row, nb.cols)} to specify
the panel display. If missing, shapes are arranged in a square.}

\item{byrow}{\code{logical}. Whether to draw successive shape by row or by col.}

\item{fromtop}{\code{logical}. Whether to display shapes from the top of the
plotting region.}

\item{cols}{A \code{vector} of colors to fill shapes.}

\item{borders}{A \code{vector} of colors to draw shape borders.}

\item{poly}{logical whether to use polygon or lines to draw shapes.
mainly for use for outlines and open outlines.}

\item{points}{logical if poly is set to FALSE whether to add points}

\item{points.pch}{if points is TRUE, a pch for these points}

\item{points.cex}{if points is TRUE, a cex for these points}

\item{points.col}{if points is TRUE, a col  for these points}

\item{...}{additional arguments to feed generic \code{plot}}
}
\value{
Returns (invisibly) a \code{data.frame} with position of shapes that
can be used for other sophisticated plotting design.
}
\description{
\code{coo_listpanel} plots a list of shapes if passed with a list of
coordinates. Mainly used by \link{panel.Coo} functions. If used outside the latter,
shapes must be "templated", see \link{coo_template}. If you want to reorder shapes
according to a factor, use \link{arrange}.
}
\examples{
coo_listpanel(bot$coo) # equivalent to panel(bot)
}
\seealso{
Other plotting functions: \code{\link{coo_arrows}},
  \code{\link{coo_draw}}, \code{\link{coo_lolli}},
  \code{\link{coo_plot}}, \code{\link{coo_ruban}},
  \code{\link{ldk_chull}}, \code{\link{ldk_confell}},
  \code{\link{ldk_contour}}, \code{\link{ldk_labels}},
  \code{\link{ldk_links}}, \code{\link{plot_devsegments}},
  \code{\link{plot_table}}
}
