% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grindr-layers.R
\name{layers}
\alias{layers}
\alias{layer_frame}
\alias{layer_axes}
\alias{layer_grid}
\alias{layer_box}
\alias{layer_fullframe}
\alias{layer_points}
\alias{layer_morphospace}
\alias{layer_ellipses}
\alias{layer_ellipsesfilled}
\alias{layer_ellipsesaxes}
\alias{layer_chull}
\alias{layer_chullfilled}
\alias{layer_stars}
\alias{layer_delaunay}
\alias{layer_density}
\alias{layer_labelpoints}
\alias{layer_labelgroups}
\alias{layer_rug}
\alias{layer_title}
\alias{layer_axesnames}
\alias{layer_eigen}
\alias{layer_axesvar}
\alias{layer_legend}
\title{grindr layers for multivariate plots}
\usage{
layer_frame(x, center_origin = TRUE, zoom = 0.9)

layer_axes(x, col = "#999999", lwd = 1/2, ...)

layer_grid(x, col = "#999999", lty = 3, grid = 3, ...)

layer_box(x, border = "#e5e5e5", ...)

layer_fullframe(x, ...)

layer_points(x, pch = 20, cex = 4/log1p(nrow(x$xy)), transp = 0, ...)

layer_morphospace(x, position = c("range", "full", "circle", "xy",
  "range_axes", "full_axes")[1], nb = 12, nr = 6, nc = 5, rotate = 0,
  size = 0.9, col = "#999999", flipx = FALSE, flipy = FALSE,
  draw = TRUE, ...)

layer_ellipses(x, conf = 0.5, lwd = 1, alpha = 0, ...)

layer_ellipsesfilled(x, conf = 0.5, lwd = 1, alpha = 0, ...)

layer_ellipsesaxes(x, conf = 0.5, lwd = 1, alpha = 0, ...)

layer_chull(x, ...)

layer_chullfilled(x, alpha = 0.8, ...)

layer_stars(x, alpha = 0.5, ...)

layer_delaunay(x, ...)

layer_density(x, levels_density = 20, levels_contour = 4, alpha = 1/3,
  n = 200, density = TRUE, contour = TRUE)

layer_labelpoints(x, col = par("fg"), cex = 2/3, font = 1,
  abbreviate = FALSE, ...)

layer_labelgroups(x, col = par("fg"), cex = 3/4, font = 2, rect = TRUE,
  alpha = 1/4, abbreviate = FALSE, ...)

layer_rug(x, size = 1/200, ...)

layer_title(x, title = "", cex = 3/4, ...)

layer_axesnames(x, cex = 3/4, name = "Axis", ...)

layer_eigen(x, nb_max = 5, cex = 1/2, ...)

layer_axesvar(x, cex = 3/4, ...)

layer_legend(x, probs = seq(0, 1, 0.25), cex = 3/4, ...)
}
\arguments{
\item{x}{a list, typically returned by \link{plot_PCA}}

\item{center_origin}{\code{logical} whether to center the origin (default \code{TRUE})}

\item{zoom}{\code{numeric} to change the zoom (default \code{0.9})}

\item{col}{color (hexadecimal) to use for drawing components}

\item{lwd}{linewidth for drawing components}

\item{...}{additional options to feed core functions for each layer}

\item{lty}{linetype for drawing components}

\item{grid}{\code{numeric} number of grid to draw}

\item{border}{color (hexadecimal) to use to draw border}

\item{pch}{to use for drawing components}

\item{cex}{to use for drawing components}

\item{transp}{transparency to use (min: 0 defaut:0 max:1)}

\item{position}{one of \code{range, full, circle,
xy, range_axes, full_axes)} to feed \link{morphospace_positions} (default \code{range})}

\item{nb}{\code{numeric} total number of shapes when \code{position="circle"} (default \code{12})}

\item{nr}{\code{numeric} number of rows to position shapes (default \code{6})}

\item{nc}{\code{numeric} number of columns to position shapes (default \code{5})}

\item{rotate}{\code{numeric} angle (in radians) to rotate shapes
when displayed on the morphospace (default \code{0})}

\item{size}{\code{numeric} size to use to feed \link{coo_template} (default \code{0.9})}

\item{flipx}{\code{logical} whether to flip shapes against the x-axis (default \code{FALSE})}

\item{flipy}{\code{logical} whether to flip shapes against the y-axis (default \code{FALSE})}

\item{draw}{\code{logical} whether to draw shapes (default \code{TRUE})}

\item{conf}{\code{numeric} between 0 and 1 for confidence ellipses}

\item{alpha}{\code{numeric} between 0 and 1 for the transparency of components}

\item{levels_density}{\code{numeric} number of levels to use to feed \code{MASS::kde2d}}

\item{levels_contour}{\code{numeric} number of levels to use to feed \code{graphics::contour}}

\item{n}{\code{numeric} number of grid points to feed \code{MASS::kde2d}}

\item{density}{\code{logical} whether to draw density estimate}

\item{contour}{\code{logical} whether to draw contour lines}

\item{font}{to feed \link{text}}

\item{abbreviate}{\code{logical} whether to abbreviate names}

\item{rect}{\code{logical} whether to draw a rectangle below names}

\item{title}{to add to the plot (default \code{""})}

\item{name}{to use on axes (default \code{"Axis"})}

\item{nb_max}{\code{numeric} number of eigen values to display (default \code{5})}

\item{probs}{\code{numeric} sequence to feed \code{stats::quantile}
and to indicate where to draw ticks and legend labels}
}
\description{
Useful layers for building custom
mutivariate plots using the cheapbabi approach. See examples.
}
\seealso{
grindr_drawers

Other grindr: \code{\link{drawers}},
  \code{\link{mosaic_engine}}, \code{\link{papers}},
  \code{\link{pile}}, \code{\link{plot_PCA}}
}
