% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-PCA.R
\name{scree}
\alias{scree}
\alias{scree.PCA}
\alias{scree.LDA}
\alias{scree_min}
\alias{scree_plot}
\title{Methods for PCA eigen values}
\usage{
scree(x, nax)

\method{scree}{PCA}(x, nax = 1:10)

\method{scree}{LDA}(x, nax = 1:10)

scree_min(x, prop = 0.99)

scree_plot(x, nax = 1:10)
}
\arguments{
\item{x}{a \link{PCA} object}

\item{nax}{numeric range of axis to consider}

\item{prop}{numeric how many axis are enough this proportion of variance, if too high then number of axis is returned.}
}
\value{
scree returns a data.frame, scree_min a numeric, scree_plot a ggplot.
}
\description{
A set of functions around PCA/LDA eigen/trace. \code{scree} calculates their proportion and cumulated proportion;
\code{scree_min} returns the minimal number of axis to use to retain a given proportion; \code{scree_plot} displays a screeplot.
}
\examples{
# On PCA
bp <- PCA(efourier(bot))
scree(bp)
scree_min(bp, 0.99)
scree_min(bp, 1)

scree_plot(bp)
scree_plot(bp, 1:5)

# on LDA, it uses svd
bl <- LDA(PCA(opoly(olea)), "var")
scree(bl)

}
