% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-out-tfourier.R
\name{tfourier_shape}
\alias{tfourier_shape}
\title{Calculates and draws 'tfourier' shapes.}
\usage{
tfourier_shape(an, bn, ao = 0, nb.h, nb.pts = 80, alpha = 2,
  plot = TRUE)
}
\arguments{
\item{an}{\code{numeric}. The \eqn{a_n} Fourier coefficients on which to
calculate a shape.}

\item{bn}{\code{numeric}. The \eqn{b_n} Fourier coefficients on which to
calculate a shape.}

\item{ao}{\code{ao} Harmonic coefficient.}

\item{nb.h}{\code{integer}. The number of harmonics to use.}

\item{nb.pts}{\code{integer}. The number of points to calculate.}

\item{alpha}{\code{numeric}. The power coefficient associated with the
(usually decreasing) amplitude of the Fourier coefficients (see
\bold{Details}).}

\item{plot}{\code{logical}. Whether to plot or not the shape.}
}
\value{
A matrix of (x; y) coordinates.
}
\description{
\code{tfourier_shape} calculates a 'Fourier tangent angle shape' given
Fourier coefficients (see \code{Details}) or can generate some 'tfourier'
shapes.
}
\examples{
tf <- tfourier(bot[1], 24)
tfourier_shape(tf$an, tf$bn) # equivalent to rfourier_i(rf)
tfourier_shape()
tfourier_shape(nb.h=6, alpha=0.4, nb.pts=500)
panel(Out(a2l(replicate(100,
coo_force2close(tfourier_shape(nb.h=6, alpha=2, nb.pts=200, plot=FALSE)))))) # biological shapes
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
\seealso{
Other tfourier: \code{\link{tfourier_i}},
  \code{\link{tfourier}}
}
