% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-palettes.R
\name{palettes}
\alias{palettes}
\alias{pal_alpha}
\alias{pal}
\alias{palette}
\alias{pal_manual}
\alias{pal_qual_solarized}
\alias{pal_seq_grey}
\alias{pal_div_BrBG}
\alias{pal_div_PiYG}
\alias{pal_div_PRGn}
\alias{pal_div_PuOr}
\alias{pal_div_RdBu}
\alias{pal_div_RdYlBu}
\alias{pal_qual_Dark2}
\alias{pal_qual_Paired}
\alias{pal_qual_Set2}
\alias{pal_seq_Blues}
\alias{pal_seq_BuGn}
\alias{pal_seq_BuPu}
\alias{pal_seq_GnBu}
\alias{pal_seq_Greens}
\alias{pal_seq_Greys}
\alias{pal_seq_Oranges}
\alias{pal_seq_OrRd}
\alias{pal_seq_PuBu}
\alias{pal_seq_PuBuGn}
\alias{pal_seq_PuRd}
\alias{pal_seq_Purples}
\alias{pal_seq_RdPu}
\alias{pal_seq_Reds}
\alias{pal_seq_YlGn}
\alias{pal_seq_YlGnBu}
\alias{pal_seq_YlOrBr}
\alias{pal_seq_YlOrRd}
\alias{pal_seq_magma}
\alias{pal_seq_inferno}
\alias{pal_seq_plasma}
\alias{pal_seq_viridis}
\alias{pal_qual}
\alias{pal_seq}
\alias{pal_div}
\title{Color palettes}
\usage{
pal_alpha(cols, transp = 0)

pal_manual(cols, transp = 0)

pal_qual_solarized(n, transp = 0)

pal_seq_grey(n, transp = 0)

pal_div_BrBG(n, transp = 0)

pal_div_PiYG(n, transp = 0)

pal_div_PRGn(n, transp = 0)

pal_div_PuOr(n, transp = 0)

pal_div_RdBu(n, transp = 0)

pal_div_RdYlBu(n, transp = 0)

pal_qual_Dark2(n, transp = 0)

pal_qual_Paired(n, transp = 0)

pal_qual_Set2(n, transp = 0)

pal_seq_Blues(n, transp = 0)

pal_seq_BuGn(n, transp = 0)

pal_seq_BuPu(n, transp = 0)

pal_seq_GnBu(n, transp = 0)

pal_seq_Greens(n, transp = 0)

pal_seq_Greys(n, transp = 0)

pal_seq_Oranges(n, transp = 0)

pal_seq_OrRd(n, transp = 0)

pal_seq_PuBu(n, transp = 0)

pal_seq_PuBuGn(n, transp = 0)

pal_seq_PuRd(n, transp = 0)

pal_seq_Purples(n, transp = 0)

pal_seq_RdPu(n, transp = 0)

pal_seq_Reds(n, transp = 0)

pal_seq_YlGn(n, transp = 0)

pal_seq_YlGnBu(n, transp = 0)

pal_seq_YlOrBr(n, transp = 0)

pal_seq_YlOrRd(n, transp = 0)

pal_seq_magma(n, transp = 0)

pal_seq_inferno(n, transp = 0)

pal_seq_plasma(n, transp = 0)

pal_seq_viridis(n, transp = 0)

pal_qual(n, transp = 0)

pal_seq(n, transp = 0)

pal_div(n, transp = 0)
}
\arguments{
\item{cols}{color(s) as hexadecimal values}

\item{transp}{\code{numeric} between 0 and 1 (0, eg opaque, by default)}

\item{n}{\code{numeric} number of colors}
}
\description{
All colorblind friendly RColorBrewer palettes
recreated without the number of colors limitation
and with transparency support thanks to \code{pal_alpha} that can be used alone.
Also, all viridis palettes (see the \href{https://CRAN.R-project.org/package=viridis}{package on CRAN}),
yet color ramps are borrowed and Momocs does not depend on it.
Also, \code{pal_qual_solarized} based on Solarized: \url{http://ethanschoonover.com/solarized}
and \code{pal_seq_grey} only shades of grey from \code{grey10} to \code{grey90}.
}
\details{
Default color palettes are currently:
\itemize{
\item \code{pal_qual=pal_qual_Set2}
\item \code{pal_seq=pal_seq_viridis}
\item \code{pal_div=pal_div_RdBu}
}
}
\note{
RColorBrewer palettes are not happy when \code{n} is lower than 3 and above
a given number for each palette. If this is the case, these functions will
create a color palette with \link{colorRampPalette} and return colors even so.
}
\examples{
pal_div_BrBG(5) \%>\% barplot(rep(1, 5), col=.)
pal_div_BrBG(5, 0.5) \%>\% barplot(rep(1, 5), col=.)
}
