% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-KMEANS.R
\name{KMEANS}
\alias{KMEANS}
\alias{KMEANS.PCA}
\title{KMEANS on PCA objects}
\usage{
KMEANS(x, ...)

\method{KMEANS}{PCA}(x, centers, nax = 1:2, pch = 20, cex = 0.5, ...)
}
\arguments{
\item{x}{PCA object}

\item{...}{additional arguments to be passed to \link{kmeans}}

\item{centers}{numeric number of centers}

\item{nax}{numeric the range of PC components to use (1:2 by default)}

\item{pch}{to draw the points}

\item{cex}{to draw the points}
}
\value{
the same thing as \link{kmeans}
}
\description{
A very basic implementation of k-means.
Beware that morphospaces are calculated so far for the 1st and 2nd
component.
}
\examples{
data(bot)
bp <- PCA(efourier(bot, 10))
KMEANS(bp, 2)
}
\seealso{
Other multivariate: 
\code{\link{CLUST}()},
\code{\link{KMEDOIDS}()},
\code{\link{LDA}()},
\code{\link{MANOVA_PW}()},
\code{\link{MANOVA}()},
\code{\link{MDS}()},
\code{\link{MSHAPES}()},
\code{\link{NMDS}()},
\code{\link{PCA}()},
\code{\link{classification_metrics}()}
}
\concept{multivariate}
