% Generated by roxygen2 (4.0.0): do not edit by hand
\name{PCdist}
\alias{PCdist}
\title{correlation between a reduced space and the original space}
\usage{
PCdist(PCs, PCscores, x = 5, plot.type = "b")
}
\arguments{
\item{PCs}{m x k matrix of Principal Components where m is the k is the
number of PCs.}

\item{PCscores}{n x m matrix of Principal Component scores where n is the
number of observations.}

\item{x}{integer: increment for every x-th PC the subspace to fullspace
correlation will be calculated.}

\item{plot.type}{"b"=barplot of correlation values, "s"=line between
correlation values.}
}
\value{
a vector of R-squared values between subspace and fullspace
distances and a barplot depicting the correlations belonging to the
subspace.
}
\description{
Calculates the correlation between distances in a reduced space and the
original space
}
\examples{
library(shapes)
a <- procSym(gorf.dat)
PCdist(a$PCs, a$PCscores, x = 2)
}
\author{
Stefan Schlager
}

