% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ComputeTransform.r
\name{computeTransform}
\alias{computeTransform}
\title{calculate an affine transformation matrix}
\usage{
computeTransform(x, y, type = c("rigid", "similarity", "affine", "tps"),
  reflection = FALSE, lambda = 1e-08)
}
\arguments{
\item{x}{fix landmarks}

\item{y}{moving landmarks}

\item{type}{set type of affine transformation: options are  "rigid", "similarity" (rigid + scale) and "affine",}

\item{reflection}{logical: if TRUE "rigid" and "similarity" allow reflections.}

\item{lambda}{numeric: regularisation parameter of the TPS.}
}
\value{
returns a 4x4 (3x3 in 2D case)  transformation matrix or an object of class "tpsCoeff" in case of type="tps".
}
\description{
calculate an affine transformation matrix
}
\details{
\code{x} and \code{y} can also be a pair of meshes with corresponding vertices.
}
\examples{
data(boneData)
trafo <- computeTransform(boneLM[,,1],boneLM[,,2])
transLM <- applyTransform(boneLM[,,2],trafo)
}

