% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtualMeshScan.r
\name{getVisibleVertices}
\alias{getVisibleVertices}
\title{find vertices visible from a given viewpoints}
\usage{
getVisibleVertices(mesh, viewpoints, offset = 0.001, cores = 1)
}
\arguments{
\item{mesh}{triangular mesh of class 'mesh3d'}

\item{viewpoints}{vector or k x 3  matrix containing a set of viewpoints}

\item{offset}{value to generate an offset at the meshes surface (see notes)}

\item{cores}{integer: number of cores to use (not working on windows)}
}
\value{
a vector with (1-based) indices of points visible from at least one of the viewpoints
}
\description{
find vertices visible from a given viewpoints
}
\note{
The function tries to filter out all vertices where the line connecting each vertex with the viewpoints intersects with the mesh itself. As, technically speaking this always occurs at a distance of value=0, a mesh with a tiny offset is generated to avoid these false hits.
}
\examples{
SCP1 <- file2mesh(system.file("extdata","SCP1.ply",package="Morpho"))
viewpoints <- read.fcsv(system.file("extdata","SCP1_Endo.fcsv",package="Morpho"))
visivert <- getVisibleVertices(SCP1,viewpoints)
}
