% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readHMD.R
\name{ReadHMD}
\alias{ReadHMD}
\title{Download Mortality and Population Data (HMD)}
\usage{
ReadHMD(what, countries = NULL, interval = "1x1", username, password,
  save = TRUE, show = TRUE)
}
\arguments{
\item{what}{What type of data are you looking for? There are available:
birth records \code{"births"}, death counts \code{"Dx"}, 
deaths by Lexis triangles \code{"lexis"}, population size \code{"population"},
exposure-to-risk \code{"Ex"}, death-rates \code{"mx"}, 
life tables for females \code{"LT_f"}, life tables for males \code{"LT_m"},
life tables both sexes combined \code{"LT_t"}, 
life expectancy at birth \code{"e0"},
cohort death-rates \code{"mxc"} and cohort exposures \code{"Exc"}.}

\item{countries}{HMD country codes.}

\item{interval}{HMD data format: (age interval x year interval).
Interval options: \code{1x1}, \code{1x5}, \code{1x10}, 
\code{5x1}, \code{5x5}, \code{5x10}.}

\item{username}{Your HMD username. If you don't have one you can sign up
for free on the Human Mortality Database website.}

\item{password}{Your HMD password.}

\item{save}{Do you want to save a copy of the dataset on your local machine? 
Logical. Default: \code{FALSE}.}

\item{show}{Choose whether to display a progress bar. Logical. Default: \code{TRUE}.}
}
\value{
A \code{ReadHMD} object that contains:
 \item{input}{List with the input values (except the password).}
 \item{data}{Data downloaded from HMD.}
 \item{download.date}{Time stamp.}
 \item{years}{Numerical vector with the years covered in the data.}
 \item{ages}{Numerical vector with ages covered in the data.}
}
\description{
Download detailed mortality and population data for different countries 
and regions in a single object from the \href{https://www.mortality.org}{
Human Mortality Database}.
}
\examples{
\dontrun{
# Download demographic data for 3 countries in 1x1 format 
age_int  <- 1  # age interval: 1,5
year_int <- 1  # year interval: 1,5,10
interval <- paste0(age_int, "x", year_int)  # --> 1x1
# And the 3 countries: Sweden Denmark and USA. We have to use the HMD codes
cntr  <- c('SWE', 'DNK', 'USA')  

# Download death counts. We don't want to export data outside R.
HMD_Dx <- ReadHMD(what = "Dx",
                  countries = cntr,
                  interval  = interval,
                  username  = "user@email.com",
                  password  = "password",
                  save = FALSE)
ls(HMD_Dx)
HMD_Dx

# Download life tables for female population and export data.
LTF <- ReadHMD(what = "LT_f",
               countries = cntr,
               interval  = interval,
               username  = "user@email.com",
               password  = "password",
               save = TRUE)
LTF
} 
}
\author{
Marius D. Pascariu
}
