% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{pT.setDimInfo}
\alias{pT.setDimInfo}
\title{Set additional information (year, description, type of risk, sex, etc.) for the pension table.}
\usage{
pT.setDimInfo(tbl, ..., append = TRUE)
}
\arguments{
\item{tbl}{The \code{pensionTable} object to assign dimensional information}

\item{...}{The dimensional information as named arguments. All names except tbl and append are allowed.}

\item{append}{Whether to append to existing dimensional data (append=TRUE) or
completely replace existing information (append=FALSE)}
}
\description{
A mortalityTable can store additional information to be used e.g. as additional
dimensions in ggplot calls. Typically, these information include sex, base
population, observation year, type of data (raw, smoothed), country, type of
risk, etc. These additional dimensions are stored in the \code{tbl@data} list
and will be used by plotMortalityTables and similar functions.
\code{pT.setDimInfo} works just like \code{mT.setDimInfo}, except that it sets
the information for all sub-tables of the pension table at the same time.
}
\examples{
# For examples, please see the \code{mT.setDimInfo} function.
}
