\name{getSavedata_Data}
\Rdversion{1.1}
\alias{getSavedata_Data}
\title{Load an analysis dataset from the SAVEDATA command into an R data.frame}
\description{
This function reads an analysis dataset generated by the Mplus SAVEDATA command
and returns an R \code{data.frame} object. 
}
\usage{
getSavedata_Data(outfile)
}
\arguments{
  \item{outfile}{required. The name of the Mplus output file to read. Can be an absolute or relative path.
  If \code{outfile} is a relative path or just the filename, then it is assumed that the file resides in
  the working directory \code{getwd()}.}
}
\value{
a \code{data.frame} containing the analysis dataset generated by the SAVEDATA command. 
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{Michael Hallquist}
\note{
Note that the \code{outfile} parameter should refer to the Mplus output file (.out extension), not the
actual dataset generated by SAVEDATA. This function reads information about the dataset from the .out file
and loads the dataset accordingly.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{getSavedata_Fileinfo}}
}
\examples{
\dontrun{
savedat <- getSavedata_Data("C:/Program Files/Mplus/Test Output.out")
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{interface}
