% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.mplusObject}
\alias{plot.mplusObject}
\title{Plot coefficients for an mplusObject}
\usage{
\method{plot}{mplusObject}(x, y, type = c("stdyx", "un", "std", "stdy"),
  ...)
}
\arguments{
\item{x}{An object of class mplusObject}

\item{y}{Not currently used}

\item{type}{A character vector indicating the type of coefficients to return.
One of \dQuote{un}, \dQuote{std}, \dQuote{stdy}, or \dQuote{stdyx}. Defaults to \dQuote{stdyx}.}

\item{\dots}{Additional arguments to pass on (not currently used)}
}
\value{
Nothing.  Called for its side effect of plotting the coefficients.
}
\description{
This is a method for plotting the coefficients of an mplusObject.
}
\examples{
\dontrun{
# simple example of a model using builtin data
# demonstrates use
test <- mplusObject(
  TITLE = "test the MplusAutomation Package;",
  MODEL = "
    mpg ON wt hp;
    wt WITH hp;",
  OUTPUT = "STANDARDIZED;",
  usevariables = c("mpg", "wt", "hp"),
  rdata = mtcars)

res <- mplusModeler(test, "mtcars.dat", modelout = "model1.inp", run = 1L)

# example of the coef method
plot(res)

# remove files
unlink("mtcars.dat")
unlink("model1.inp")
unlink("model1.out")
unlink("Mplus Run Models.log")
}
}
\author{
Joshua F. Wiley <jwiley.psych@gmail.com>
}
\keyword{interface}
