% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplus.R
\name{mplusRcov}
\alias{mplusRcov}
\title{Create Mplus code for various residual covariance structures.}
\usage{
mplusRcov(x, type = c("homogenous", "heterogenous", "cs", "toeplitz", "ar",
  "un"), r = "rho", e = "e", collapse = FALSE)
}
\arguments{
\item{x}{input character vector of variable names, ordered by time}

\item{type}{A character string indicating the type of residual covariance
structure to be used. Defaults to \sQuote{homogenous}. Current options include
\sQuote{homogenous}, \sQuote{heterogenous}, \sQuote{cs} for compound symmetric,
\sQuote{toeplitz} for banded toeplitz, \sQuote{ar} for autoregressive, and
\sQuote{un} for unstructured.}

\item{r}{a character vector of the base label to name covariance parameters.
Defaults to \sQuote{rho}.}

\item{e}{a character vector of the error variance of the variable.
Used to create constraints on the covariance parameters. Defaults to \sQuote{e}.}

\item{collapse}{whether to collapse the covariance code using \sQuote{PWITH}. Note that
at the time of writing, Mplus does not allow more than 80 characters per row.
Defaults to \code{FALSE}.}
}
\value{
A named character vector of class \sQuote{MplusRstructure} with four elements:
  \item{all}{A character string collapsing all other sections.}
  \item{Variances}{A character string containing all of the variances.}
  \item{Covariances}{A character string containing all of the
    covariances, properly labelled to allow constraints and the
    autoregressive residual covariance structure.}
  \item{Constraints}{A character string containing the \sQuote{MODEL CONSTRAINT}
    section and code needed to parameterize the residual covariance structure
    as autoregressive.}
}
\description{
This function makes it easy to write the Mplus syntax for various
residual covariance structure.
}
\details{
The \strong{homogenous} residual covariance structure estimates one parameter:
the residual variance, \eqn{\sigma^{2}_{e}}{s^2}. The residual variance
is assumed to be identical for all variables and all covariances are
assumed to be zero. The structure is represented in this table.
\tabular{llllll}{
    \tab t1 \tab t2 \tab t3 \tab \ldots \tab tn \cr
  t1 \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \tab \tab \ldots \tab \cr
  t2 \tab 0 \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \tab \ldots \tab \cr
  t3 \tab 0 \tab 0 \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \ldots \tab \cr
  \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \cr
  tn \tab 0 \tab 0 \tab 0 \tab \ldots \tab \eqn{\sigma^{2}_{e}}{s^2} \cr
}

The \strong{heterogenous} residual covariance structure estimates
\bold{n} parameters, where \bold{n} is the number of variables.
A unique residual variance is estimated for every variable. All
covariances are assumed to be zero. The structure is represented in this table.
\tabular{llllll}{
    \tab t1 \tab t2 \tab t3 \tab \ldots \tab tn \cr
  t1 \tab \eqn{\sigma^{2}_{e1}}{s1^2} \tab \tab \tab \ldots \tab \cr
  t2 \tab 0 \tab \eqn{\sigma^{2}_{e2}}{s2^2} \tab \tab \ldots \tab \cr
  t3 \tab 0 \tab 0 \tab \eqn{\sigma^{2}_{e3}}{s3^2} \tab \ldots \tab \cr
  \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \cr
  tn \tab 0 \tab 0 \tab 0 \tab \ldots \tab \eqn{\sigma^{2}_{en}}{sn^2} \cr
}

The \strong{compound symmetric} residual covariance structure estimates
two parameters: one for the residual variance , \eqn{\sigma^{2}_{e}}{s^2},
and one for the covariance. The residual variance
is assumed to be identical for all variables and all covariances are
assumed to be identical. The structure is represented in this table.
\tabular{llllll}{
    \tab t1 \tab t2 \tab t3 \tab \ldots \tab tn \cr
  t1 \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \tab \tab \ldots \tab \cr
  t2 \tab \eqn{\rho}{rho} \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \tab \ldots \tab \cr
  t3 \tab \eqn{\rho}{rho} \tab \eqn{\rho}{rho} \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \ldots \tab \cr
  \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \cr
  tn \tab \eqn{\rho}{rho} \tab \eqn{\rho}{rho} \tab \eqn{\rho}{rho} \tab \ldots \tab \eqn{\sigma^{2}_{e}}{s^2} \cr
}

The \strong{toeplitz} residual covariance structure estimates
\bold{n} parameters, one for every band of the matrix.
The residual variance , \eqn{\sigma^{2}_{e}}{s^2}, is
assumed to be identical for all variables. The covariances one step removed
are all assumed identical. Likewise for all further bands.
The structure is represented in this table.
\tabular{llllll}{
    \tab t1 \tab t2 \tab t3 \tab \ldots \tab tn \cr
  t1 \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \tab \tab \ldots \tab \cr
  t2 \tab \eqn{\rho}{rho} \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \tab \ldots \tab \cr
  t3 \tab \eqn{\rho_{2}}{rho2} \tab \eqn{\rho}{rho} \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \ldots \tab \cr
  \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \cr
  tn \tab \eqn{\rho_{n}}{rhon} \tab \eqn{\rho_{n - 1}}{rho(n - 1)} \tab \eqn{\rho_{n - 2}}{rho(n - 2)} \tab \ldots \tab \eqn{\sigma^{2}_{e}}{s^2} \cr
}

The \strong{autoregressive} residual covariance structure has two parameters:
the residual variance, \eqn{\sigma^{2}_{e}}{s^2} and
the correlation between adjacent time points, \eqn{\rho}{rho}. The variances
are constrained to be equal for all time points. A single correlation
parameter is estimated. The \eqn{\rho}{rho} is the correlation between adjacent
time points such as 1 and 2 or 2 and 3. More distant relationships are assumed
to have smaller correlations, decreasing exponentially. Thus between 1 and 3,
the estimate is \eqn{\rho^2}{rho^2}. The structure is represented in this table.
\tabular{llllll}{
    \tab t1 \tab t2 \tab t3 \tab \ldots \tab tn \cr
  t1 \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \tab \tab \ldots \tab \cr
  t2 \tab \eqn{\rho}{rho} \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \tab \ldots \tab \cr
  t3 \tab \eqn{\rho^2}{rho^2} \tab \eqn{\rho}{rho} \tab \eqn{\sigma^{2}_{e}}{s^2} \tab \ldots \tab \cr
  \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \cr
  tn \tab \eqn{\rho^{n-1}}{rho^(n-1)} \tab \eqn{\rho^{n-2}}{rho^(n-2)} \tab \eqn{\rho^{n-3}}{rho^(n-3)} \tab \ldots \tab \eqn{\sigma^{2}_{e}}{s^2} \cr
}
Because structural equation models generally model covariance structures,
the autoregressive residual structure must be parameterized in terms of
covariances. This is done in two parts. First, the function returns
syntax to estimate all the pairwise covariances, labelling the parameters
\eqn{\rho}{rho}, \eqn{\rho^2}{rho^2}, etc. so that they are constrained to be
equal. Next, it returns the syntax for the necessary model constraints to
constrain the different covariances, to decrease exponentially in their
correlations. This is done via:
\deqn{\rho^2 = (\frac{\rho}{\sigma^2_{e}})^{2}\sigma^2_{e}}{rho^2 = (rho/s^2)^2 * s^2}
and likewise for all later time points.

The \strong{unstructured} residual covariance structure estimates
\eqn{\frac{n(n + 1)}{2}}{(n(n + 1))/2} parameters. It is unstructured
in that every variance and covariance is freely estimated with no
constraints. However, in most cases, this results in an overparameterized
model and is unestimable. The structure is represented in this table.

\tabular{llllll}{
    \tab t1 \tab t2 \tab t3 \tab \ldots \tab tn \cr
  t1 \tab \eqn{\sigma^{2}_{e1}}{s1^2} \tab \tab \tab \ldots \tab \cr
  t2 \tab \eqn{\rho_{1}}{rho1} \tab \eqn{\sigma^{2}_{e2}}{s2^2} \tab \tab \ldots \tab \cr
  t3 \tab \eqn{\rho_{2}}{rho2} \tab \eqn{\rho_{3}}{rho3} \tab \eqn{\sigma^{2}_{e3}}{s3^2} \tab \ldots \tab \cr
  \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \tab \ldots \cr
  tn \tab \eqn{\rho_{5}}{rho5} \tab \eqn{\rho_{6}}{rho6} \tab \eqn{\rho_{7}}{rho7} \tab \ldots \tab \eqn{\sigma^{2}_{en}}{sn^2} \cr
}
}
\examples{
# all five structures collapsing
mplusRcov(letters[1:4], "homogenous", "rho", "e", TRUE)
mplusRcov(letters[1:4], "heterogenous", "rho", "e", TRUE)
mplusRcov(letters[1:4], "cs", "rho", "e", TRUE)
mplusRcov(letters[1:4], "toeplitz", "rho", "e", TRUE)
mplusRcov(letters[1:4], "ar", "rho", "e", TRUE)
mplusRcov(letters[1:4], "un", "rho", "e", TRUE)

# all five structures without collapsing
# useful for long names or many variables
# where a line may cross 80 characters
mplusRcov(letters[1:4], "homogenous", "rho", "e", FALSE)
mplusRcov(letters[1:4], "heterogenous", "rho", "e", FALSE)
mplusRcov(letters[1:4], "cs", "rho", "e", FALSE)
mplusRcov(letters[1:4], "toeplitz", "rho", "e", FALSE)
mplusRcov(letters[1:4], "ar", "rho", "e", FALSE)
mplusRcov(letters[1:4], "un", "rho", "e", FALSE)
}
\author{
Joshua F. Wiley <jwiley.psych@gmail.com>
}
\keyword{interface}
