% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{confint.mplus.model}
\alias{confint.mplus.model}
\alias{confint.mplusObject}
\title{Return confidence intervals for an mplus.model object}
\usage{
\method{confint}{mplus.model}(
  object,
  parm,
  level = 0.95,
  type = c("un", "std", "stdy", "stdyx"),
  params = c("regression", "loading", "undirected", "expectation", "variability", "new"),
  ...
)

\method{confint}{mplusObject}(object, ...)
}
\arguments{
\item{object}{An object of class mplusObject}

\item{parm}{Included as all \code{confint()} methods must include it.  Not used
currently for Mplus.}

\item{level}{A numeric vector indicating the level of confidence interval to extract.
Options are .95, .90, or .99 as those are all Mplus provides.}

\item{type}{A character vector indicating the type of confidence intervals
to return. One of \dQuote{un}, \dQuote{std}, \dQuote{stdy}, or \dQuote{stdyx}.}

\item{params}{A character vector indicating what type of parameters to
extract.  Any combination of \dQuote{regression}, \dQuote{loading},
\dQuote{undirected}, \dQuote{expectation}, \dQuote{variability}, and
\dQuote{new}.  A single one can be passed or multiple.  By default, all
are used and all parameters are returned.}

\item{\dots}{Additional arguments to pass on (not currently used)}
}
\value{
A data frame of class \sQuote{mplus.model.cis}, or in
  the case of multiple group models, a list of class \sQuote{mplus.model.cis},
  where each element of the list is a data frame of class \sQuote{mplus.model.cis}.
}
\description{
This is a method for returning the confidence of an mplus.model object.
It works directly on an object stored from \code{readModels} such as:
\code{object <- readModels("/path/to/model/model.out")}.

Method that calls \code{confint.mplus.model}.
See further documentation there.
}
\examples{
\dontrun{
# simple example of a model using builtin data
# demonstrates use
test <- mplusObject(
  TITLE = "test the MplusAutomation Package;",
  MODEL = "
    mpg ON wt hp;
    wt WITH hp;",
  OUTPUT = "STANDARDIZED; CINTERVAL;",
  usevariables = c("mpg", "wt", "hp"),
  rdata = mtcars)

res <- mplusModeler(test, "mtcars.dat", modelout = "model1.inp", run = 1L)

# example of the confint method on an mplus.model object
# note that res$results holds the results of readModels()
confint(res$results)
confint(res$results, type = "std")
confint(res$results, type = "stdy")
confint(res$results, type = "stdyx", level = .99)

# there is also a method for mplusObject class
confint(res)
screenreg(res, cis = TRUE, single.row = TRUE)

# remove files
unlink("mtcars.dat")
unlink("model1.inp")
unlink("model1.out")
unlink("Mplus Run Models.log")
}
}
\seealso{
\code{\link{readModels}}

Other Mplus-Formatting: 
\code{\link{coef.mplus.model}()},
\code{\link{extract}()},
\code{\link{print.MplusRstructure}()},
\code{\link{summary.mplusObject}()}
}
\author{
Joshua F. Wiley <jwiley.psych@gmail.com>
}
\concept{Mplus-Formatting}
\keyword{interface}
