% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrsimp.R
\name{MrSImp}
\alias{MrSImp}
\title{Variable importance for predictive variables}
\usage{
MrSImp(
  dataframe,
  role,
  B = 100,
  bestK = 1,
  maxDepth = 5,
  minTrt = 5,
  minData = max(c(minTrt * maxDepth, NROW(Y)/20)),
  batchNum = 1L,
  faster = FALSE,
  display = FALSE,
  treeName = paste0("tree_", format(Sys.time(), "\%m\%d"), ".yaml"),
  nodeName = paste0("node_", format(Sys.time(), "\%m\%d"), ".txt"),
  impName = paste0("imp_", format(Sys.time(), "\%m\%d"), ".txt")
)
}
\arguments{
\item{dataframe}{train data frame}

\item{role}{role follows GUIDE role}

\item{B}{bootstrap number default = 100}

\item{bestK}{number of covariates in the regression model}

\item{maxDepth}{maximum tree depth}

\item{minTrt}{minimum treatment and placebo sample in each node}

\item{minData}{minimum sample in each node}

\item{batchNum}{related with exhaustive search for numerical split variable}

\item{faster}{related with tree split searching}

\item{display}{Whether display tree in the end}

\item{treeName}{yaml file for save the tree}

\item{nodeName}{file same for each node}

\item{impName}{important variable file name}
}
\value{
A list contains importance score variable names and roles
\item{imp}{Importance score data frame}
\item{role}{Role for each variable}
\item{Settings}{Settings used to build the tree}
}
\description{
Variable importance in subgroup identification for predictive variables.
}
\details{
MrSGUIDE variable importance
}
\examples{
library(MrSGUIDE)
set.seed(1234)

N = 200
np = 3

numX <- matrix(rnorm(N * np), N, np) ## numerical features
gender <- sample(c('Male', 'Female'), N, replace = TRUE)
country <- sample(c('US', 'UK', 'China', 'Japan'), N, replace = TRUE)

z <- sample(c(0, 1), N, replace = TRUE) # Binary treatment assignment

y1 <- numX[, 1] + 1 * z * (gender == 'Female') + rnorm(N)
y2 <- numX[, 2] + 2 * z * (gender == 'Female') + rnorm(N)

train <- data.frame(numX, gender, country, z, y1, y2)
role <- c(rep('n', 3), 'c', 'c', 'r', 'd', 'd')

mrsobj <- MrSImp(dataframe = train, role = role, B = 10)
mrsobj$imp


}
\author{
Peigen Zhou
}
