% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{printTree}
\alias{printTree}
\title{Print fitted regression tree}
\usage{
printTree(mrsobj, digits = 3, details = TRUE, ...)
}
\arguments{
\item{mrsobj}{MrSGUIDE object}

\item{digits}{digits pass to coefficient}

\item{details}{whether to print fitting details}

\item{...}{parameter pass to \code{print_node}}
}
\value{
print tree information into console
}
\description{
Print fitted regression tree
}
\examples{
library(MrSGUIDE)
set.seed(1234)

N = 200
np = 3

numX <- matrix(rnorm(N * np), N, np) ## numerical features
gender <- sample(c('Male', 'Female'), N, replace = TRUE)
country <- sample(c('US', 'UK', 'China', 'Japan'), N, replace = TRUE)

z <- sample(c(0, 1), N, replace = TRUE) # Binary treatment assignment

y1 <- numX[, 1] + 1 * z * (gender == 'Female') + rnorm(N)
y2 <- numX[, 2] + 2 * z * (gender == 'Female') + rnorm(N)

train <- data.frame(numX, gender, country, z, y1, y2)
role <- c(rep('n', 3), 'c', 'c', 'r', 'd', 'd')

mrsobj <- MrSFit(dataframe = train, role = role)
printTree(mrsobj, digits = 2, details=TRUE)
printTree(mrsobj, digits = 2, details=FALSE)

}
