% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ring_calculate.R
\name{ring_calculate}
\alias{ring_calculate}
\title{Generate a ring-width series}
\usage{
ring_calculate(ring.data, seriesID)
}
\arguments{
\item{ring.data}{A matrix or array produced by \code{\link{ring_detect}} 
or \code{\link{ring_modify}}.}

\item{seriesID}{A character string specifying the column name of 
the ring-width series.}
}
\value{
A data frame. The series ID is the column name 
and years are row names. The measurements units are millimeters (mm).
}
\description{
This function can calculate ring widths according to 
coordinates of detected ring borders.
}
\examples{
img.path <- system.file("001.png", package = "MtreeRing")

## Read a tree ring image:
t1 <- ring_read(img = img.path, dpi = 1200)

## Split a long core sample into 3 pieces to
## get better display performance and use the
## watershed algorithm to detect ring borders:
t2 <- ring_detect(ring.data = t1, seg = 3, method = 'watershed')

## Calculate ring widths from the attribute list of t2:
rw.df <- ring_calculate(ring.data = t2, seriesID = "940220")
}
\author{
Jingning Shi
}
