% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A0N__computeBnAn.R
\name{A0N__computeBnAn_sepQ}
\alias{A0N__computeBnAn_sepQ}
\title{Compute the cross-section loadings of yields of a canonical A0_N model ("sep Q" models)}
\usage{
A0N__computeBnAn_sepQ(mat, K1XQ, dx, r0, SSX)
}
\arguments{
\item{mat}{vector of maturities (J x 1). Maturities are in multiples of the discrete interval
used in the model}

\item{K1XQ}{risk neutral feedback matrix (N x N)}

\item{dx}{state loadings for the one-period rate (1xN). Default is a vector of ones}

\item{r0}{the long run risk neutral mean of the short rate (scalar)}

\item{SSX}{the covariance matrix of the errors (N x N)}
}
\value{
List containing:
\itemize{
\item Intercept (Jx1)
\item slope (JxN)
\item the betan (JX1, part of the intercepts unrelated to the long run risk neutral mean r0)
coefficients of a canonical A_0(N).
}
}
\description{
Compute the cross-section loadings of yields of a canonical A0_N model ("sep Q" models)
}
\references{
\itemize{
 \item This function is based on the "A0N__computeBnAn" function by Le and Singleton (2018). \cr
 "A Small Package of Matlab Routines for the Estimation of Some Term Structure Models." \cr
 (Euro Area Business Cycle Network Training School - Term Structure Modelling).
 Available at: https://cepr.org/40029

 \item Dai and Singleton (2000). "Specification Analysis of Affine Term Structure Models" (The Journal of Finance)
 }
}
