% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiasCorrection.R
\name{estVARbrw}
\alias{estVARbrw}
\title{Estimate a VAR(1) - suited to Bauer, Rudebusch and Wu (2012) methodology}
\usage{
estVARbrw(
  RiskFactors,
  ModelType,
  N,
  GVARinputs,
  JLLinputs,
  FactorLabels,
  Economies,
  demean = FALSE,
  intercept = TRUE
)
}
\arguments{
\item{RiskFactors}{time series of the risk factors (T x F)}

\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{N}{number of country-specific spanned factors (scalar)}

\item{GVARinputs}{inputs used in the estimation of the GVAR-based models (see "GVAR" function)}

\item{JLLinputs}{inputs used in the estimation of the JLL-based models (see "JLL" function)}

\item{FactorLabels}{string-list based which contains the labels of all variables present in the model}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{demean}{demean the data before estimation. Default is set to FALSE}

\item{intercept}{Include intercept in the VAR model. Default is set to TRUE}
}
\value{
list containing VAR(1) parameters
#'\enumerate{
\item Gamma_hat: feedback matrix (F X F)
\item alpha_hat: intercept (F x 1)
}

#'@references
Bauer, Rudebusch and, Wu (2012). "Correcting Estimation Bias in Dynamic Term Structure Models". \cr
This function is similar to the "estVAR" Matlab function available at Cynthia Wu's website
(https://sites.google.com/view/jingcynthiawu/).
}
\description{
Estimate a VAR(1) - suited to Bauer, Rudebusch and Wu (2012) methodology
}
