% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{Bootstrap}
\alias{Bootstrap}
\title{Generates the bootstrap-related outputs}
\usage{
Bootstrap(
  ModelType,
  ModelParaPE,
  NumOutPE,
  mat,
  Economies,
  InputsForOutputs,
  FactorLabels,
  DataFrequency,
  vararginPE,
  JLLinputs = NULL,
  GVARinputs = NULL,
  BRWinputs = NULL
)
}
\arguments{
\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{ModelParaPE}{point estimate from the model parameters (see the outputs of the "Optimization" function)}

\item{NumOutPE}{point estimate from the numerical outputs (see the outputs of the "NumOutputs" function)}

\item{mat}{vector of maturities (in years) used in the estimation}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{InputsForOutputs}{list containing the desired inputs for the construction of IRFs, GIRFs, FEVDs, and GFEVDs.}

\item{FactorLabels}{string-list based which contains the labels of all the variables present in the model}

\item{DataFrequency}{character-based vector: "Daily All Days", "Daily Business Days", "Weekly", "Monthly", "Quarterly", "Annually"}

\item{vararginPE}{list containg starting values and constraints (see arguments of the "Optimization" function)}

\item{JLLinputs}{list of necessary inputs for the estimation of JLL-based models (see "JLL" function)}

\item{GVARinputs}{list of necessary inputs for the estimation of GVAR-based models (see "GVAR" function)}

\item{BRWinputs}{list of necessary inputs for performing the bias-corrected estimation (see "Bias_Correc_VAR" function)}
}
\value{
list containing the following elements:
\itemize{
\item list of model parameters for one each one the draws;
\item list of numerical outputs (IRFs, GIRFs, FEVDs, GFEVDs) for each one of the draws;
\item Confidence bands for the chosen level of significance.
}
}
\description{
Generates the bootstrap-related outputs
}
\examples{
# See examples in the vignette file of this package (Section 4).

}
\references{
This function is a modified and extended version of the "VARirbound" function from "A toolbox for VAR analysis"
by Ambrogio Cesa-Bianchi (https://github.com/ambropo/VAR-Toolbox)
}
