% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOpt.R
\name{BuildATSM_RiskFactors}
\alias{BuildATSM_RiskFactors}
\title{Builds the time series of the risk factors that are used in the estimation of the ATSM}
\usage{
BuildATSM_RiskFactors(
  InitialSampleDate,
  FinalSampleDate,
  Yields,
  GlobalMacroFactors,
  DomMacroFactors,
  Economies,
  FactorLabels,
  ModelType,
  BS_Adj = FALSE
)
}
\arguments{
\item{InitialSampleDate}{Sample starting date}

\item{FinalSampleDate}{Sample last date}

\item{Yields}{matrix  (J x T), where  J - the number of maturities and  T - time series length}

\item{GlobalMacroFactors}{time series of the global macroeconomic risk factors (G x T)}

\item{DomMacroFactors}{time series of the country-specific macroeconomic risk factors for all C countries (CM x T)}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{FactorLabels}{string-list based which contains the labels of all variables present in the model}

\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{BS_Adj}{adjustment of global series for sepQ model in the Bootstrap setting. Default is set to FALSE.}
}
\value{
Generates the complete set of risk factors that are used in the estimation of the ATSM
}
\description{
Builds the time series of the risk factors that are used in the estimation of the ATSM
}
\keyword{internal}
