% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiasCorrection.R
\name{Check_comparison__OLS}
\alias{Check_comparison__OLS}
\title{check whether mean/median of OLS is close to actual OLS estimates}
\usage{
Check_comparison__OLS(
  theta_tilde,
  theta_OLS,
  B_check,
  RiskFactors,
  N,
  GVARinputs,
  JLLinputs,
  FactorLabels,
  Economies,
  ModelType
)
}
\arguments{
\item{theta_tilde}{feedback matrix after the bias correction procedure}

\item{theta_OLS}{feedback matrix obtained by OLS estimation (without bias correction)}

\item{B_check}{number of bootstrap samples used in the closeness check}

\item{RiskFactors}{time series of the risk factors (F x T)}

\item{N}{number of country-specific spanned factors (scalar)}

\item{GVARinputs}{inputs used in the estimation of the GVAR-based models (see "GVAR" function). Default is set to NULL}

\item{JLLinputs}{inputs used in the estimation of the JLL-based models (see "JLL" function). Default is set to NULL}

\item{FactorLabels}{string-list based which contains the labels of all variables present in the model}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{ModelType}{string-vector containing the label of the model to be estimated}
}
\description{
check whether mean/median of OLS is close to actual OLS estimates
}
\keyword{internal}
