% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiFit.R
\name{uvExactNull}
\alias{uvExactNull}
\title{Exact univariate null distribution}
\usage{
uvExactNull(uv.null.sim, test.method, correct = TRUE, col0.tot, row0.tot,
  grand.tot, top.max.ps = 4L, verbose = FALSE)
}
\arguments{
\item{uv.null.sim}{Positive integer, the number of simulated values to be computed
in a univariate case when an exact or approximate null distribution is simulated.}

\item{test.method}{String, "Fisher" and "norm.approx" are applicable here.}

\item{correct}{Logical, relates to Fisher's exact test, if \code{TRUE} the exact
null is simulated for the mid-\code{p} corrected \code{p}-values.}

\item{col0.tot}{Numerical vector, containing the column-0 totals of all 2x2 contingency
tables for which simulated values are asked for. Has to be the same length as \code{row0.tot}
and \code{grand.tot}.}

\item{row0.tot}{Numerical vector, containing the row-0 totals of all 2x2 contingency
tables for which simulated values are asked for. Has to be the same length as \code{col0.tot}
and \code{grand.tot}.}

\item{grand.tot}{Numerical vector, containing the totals of all 2x2 contingency
tables for which simulated values are asked for. Has to be the same length as \code{col0.tot}
and \code{row0.tot}.}

\item{top.max.ps}{Positive integer, report the mean of the top \code{top.max.ps}
order statistics of the negative logarithm of all \code{p}-values.}

\item{verbose}{Logical.}
}
\value{
List of two numerical vectors for each of the global test statistics. Each
such vector is of length \code{uv.null.sim}.
}
\description{
In a univariate case, simulate an exact null distribution for the global
test statistics.
}
