/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.io.Serializable;

public final class TimingStatistics
implements Serializable {
    private int nCalls;
    private long minTime;
    private long maxTime;
    private long sumTime;
    private double sumSquaredTime;

    public TimingStatistics() {
    }

    public TimingStatistics(int nCalls, long minTime, long maxTime, long sumTime, double sumSquaredTime) {
        this.nCalls = nCalls;
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.sumTime = sumTime;
        this.sumSquaredTime = sumSquaredTime;
    }

    public synchronized int getNCalls() {
        return this.nCalls;
    }

    public synchronized long getMinTime() {
        return Math.max(0L, this.minTime);
    }

    public synchronized long getMaxTime() {
        return this.maxTime;
    }

    public synchronized long getSumTime() {
        return this.sumTime;
    }

    public synchronized double getSumSquaredTime() {
        return this.sumSquaredTime;
    }

    public synchronized long getMeanTime() {
        return this.nCalls == 0 ? 0L : this.sumTime / (long)this.nCalls;
    }

    public synchronized long getStdDevTime() {
        if (this.nCalls == 0) {
            return 0L;
        }
        double meanOfSquares = this.sumSquaredTime / (double)this.nCalls;
        double mean = this.getMeanTime();
        double meanSquared = mean * mean;
        double variance = meanOfSquares - meanSquared;
        if (variance < 0.0) {
            return 0L;
        }
        return (long)Math.sqrt(variance);
    }

    public synchronized String toString() {
        return "\nnCalls = " + this.nCalls + ";\n" + "sum = " + (double)this.sumTime / 1.0E9 + "s;\n" + "min = " + (double)this.minTime / 1000000.0 + "ms;\n" + "max = " + (double)this.maxTime / 1000000.0 + "ms;\n" + "mean = " + (double)this.getMeanTime() / 1000000.0 + "ms;\n" + "stdDev = " + (double)this.getStdDevTime() / 1000000.0 + "ms;";
    }

    public Call newCall() {
        return new Call();
    }

    public final class Call {
        private final long startTime = System.nanoTime();

        private Call() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() {
            long elapsed = System.nanoTime() - this.startTime;
            TimingStatistics timingStatistics = TimingStatistics.this;
            synchronized (timingStatistics) {
                TimingStatistics.this.nCalls++;
                if (elapsed < TimingStatistics.this.minTime || TimingStatistics.this.nCalls == 1) {
                    TimingStatistics.this.minTime = elapsed;
                }
                if (elapsed > TimingStatistics.this.maxTime) {
                    TimingStatistics.this.maxTime = elapsed;
                }
                TimingStatistics.this.sumTime += elapsed;
                TimingStatistics.this.sumSquaredTime += elapsed * elapsed;
            }
        }
    }
}

