% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice_reuse.R
\name{mice.reuse}
\alias{mice.reuse}
\title{Reuseble mice function}
\usage{
mice.reuse(mids, newdata, maxit = 5, printFlag = TRUE, seed = NA)
}
\arguments{
\item{mids}{: mids object
An object of class mids, typically produces by a previous call to mice() or mice.mids()}

\item{newdata}{: data.frame
Previously unseen data of the same structur as used to generate `mids`}

\item{maxit}{: integer scalar
The number of additional Gibbs sampling iterations to refine the new imputations}

\item{printFlag}{: logical scalar
A Boolean flag. If TRUE, diagnostic information during the Gibbs sampling iterations
will be written to the command window. The default is TRUE.}

\item{seed}{: integer scalar
An integer that is used as argument by the set.seed() for offsetting the random
number generator. Default is to use the last seed value stored in `mids`}
}
\value{
data : list of data.frames
  the imputations of newdata


 lastSeedValue : integer vector
   the random seed at the end of the procedure
}
\description{
Reuse a previously fit multivariate imputation by chained equations to
impute values for previously unseen data without changing the imputation
fit (i.e. solely use the original training data to guide the imputation
models).

Note: see https://github.com/stefvanbuuren/mice/issues/32 for discussion
}
\author{
Patrick Rockenschaub git https://github.com/prockenschaub
}
