% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.nblda.R, R/zzz_methods.R
\docType{methods}
\name{predict}
\alias{predict}
\alias{predict.nblda}
\alias{predict,nblda-method}
\title{Extract predictions from NBLDA model}
\usage{
\method{predict}{nblda}(object, test.data, return = c("predictions",
  "everything"), ...)

\S4method{predict}{nblda}(object, test.data, return = c("predictions",
  "everything"), ...)
}
\arguments{
\item{object}{a \code{nblda} object returned from \code{\link{trainNBLDA}}.}

\item{test.data}{a data frame or matrix whose class labels to be predicted.}

\item{return}{what should be returned? Predicted class labels or eveything?}

\item{\dots}{further arguments to be passed to or from methods.}
}
\value{
It is possible to return only predicted class labels or a list with elements which are used within prediction
process. These arguements are as follows:
\item{xte}{count data for test set.}
\item{nste}{normalized count data for test set.}
\item{ds}{estimates of offset parameter for each variable. See notes.}
\item{discriminant}{discriminant scores of each subject.}
\item{prior}{prior probabilities for each class.}
\item{ytehat}{predicted class labels for test set.}
\item{alpha}{power transformation parameter. If no transformation is requested, it returns NULL.}
\item{type}{normalization method.}
\item{dispersions}{dispersion estimates of each variable.}
}
\description{
This function predicts the class labels of test data for a given model.
}
\note{
\code{d_kj} is simply used to re-parameterize the Negative Binomial mean as s_i*g_j*d_kj where s_i is the size
factor for subject i, g_j is the total count of variable j and d_kj is the offset parameter for variable j at class k.
}
\examples{
set.seed(2128)
counts <- generateCountData(n = 20, p = 10, K = 2, param = 1, sdsignal = 0.5, DE = 0.8,
                            allZero.rm = FALSE, tag.samples = TRUE)
x <- t(counts$x + 1)
y <- counts$y
xte <- t(counts$xte + 1)
ctrl <- nbldaControl(folds = 2, repeats = 2)

fit <- trainNBLDA(x = x, y = y, type = "mle", tuneLength = 10,
                  metric = "accuracy", train.control = ctrl)

predict(fit, xte)

}
\author{
Dincer Goksuluk
}
