% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restructure_data.R
\name{ingest_data}
\alias{ingest_data}
\title{Ingest and stack variables needed in calibration.}
\usage{
ingest_data(inname, analyte, name_fix = TRUE, amb_avg, ref_avg)
}
\arguments{
\item{inname}{A file (or list of files) to extract data from for calibration.}

\item{analyte}{Carbon (Co2) or water (H2o)?}

\item{name_fix}{Fix to data frame required for next-generation calibration
functions, but breaks old 'by_month()' functions. This
parameter provides a necessary work around until these
functions are removed.}

\item{amb_avg}{The averaging interval of the ambient data to extract.}

\item{ref_avg}{The averaging interval of the reference data to extract.}
}
\value{
List of data frames, taken from files specified in \code{inname}
}
\description{
Opens and stacks isotope ratio and water/carbon dioxide mole fraction
variables from monthly HDF5 files. If a new enough version of \code{neonUtilities}
is available, this function will try to use \code{fasttime} in order to accelerate
data stacking.
}
\author{
Rich Fiorella \email{rfiorella@lanl.gov}
}
