% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_pts_fourth.R
\name{expected_pts_fourth}
\alias{expected_pts_fourth}
\title{Decision for 4th downs based on expected points}
\usage{
expected_pts_fourth(yards_from_goal, yards_to_go, play_data)
}
\arguments{
\item{yards_from_goal}{The number of yards until a team scores a touchdown}

\item{yards_to_go}{Number of yards to go until a first down or TD}

\item{play_data}{A data file from nflscrapR prepped using the prep_pbp_data.R function}
}
\value{
A data.frame of the expected points of three fourth down options
}
\description{
This function will return the expected points for several 
4th down decision. The options are "go for it",
"field goal", or "punt".  This should be primarily
used within the `NFLSimulatoR::sample_play()` function.
}
\examples{
\dontrun{
expected_pts_fourth(what_down = 1,
                      yards_to_go = 10,
                      yards_from_own_goal = 25,
                      play_by_play_data = reg_pbp_2018)
}
}
