% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmAddPCA}
\alias{chmAddPCA}
\title{Add PCA coordinates to an NG-CHM.}
\usage{
chmAddPCA(hm, axis, prc, basename = "PC", ndim = 2)
}
\arguments{
\item{hm}{The NGCHM to add the coordinates to.}

\item{axis}{The NGCHM axis ("row" or "column") to add the coordinates to.}

\item{prc}{Principal component coordinates (output of \code{\link[stats:prcomp]{stats::prcomp()}}) for the specified NGCHM axis.}

\item{basename}{The prefix to use for the coordinate names.}

\item{ndim}{The maximum number of coordinates to add.}
}
\value{
The NGCHM with added coordinates.
}
\description{
Add PCA coordinates as hidden covariate bars to an axis of an NG-CHM.
One hidden covariate bar is added for each PCA coordinate (up to ndim coordinates).
Coordinates are given names 'BASENAME.coordinate.N', where BASENAME is specified by the
parameter basename (default "PC") and N ranges from 1 to the number of added covariate bars.
}
\examples{
# Examples using `chmNew()` require git to be installed.
\dontrun{
  # If the NGCHMDemoData package is installed, use it to demo usage
  if (requireNamespace("NGCHMDemoData", quietly = TRUE)) {
   data(TCGA.GBM.EXPR, package = "NGCHMDemoData")
    prc <- prcomp(TCGA.GBM.EXPR[1:50, 1:50])
    hm <- chmNew("gbm", TCGA.GBM.EXPR[1:50, 1:50])
    hm <- chmAddPCA(hm, "column", prc)
  }
  # Small example not requiring NGCHMDemoData
  matrix <- matrix(rnorm(100),
    nrow = 10, ncol = 10,
    dimnames = list(paste0("r", 1:10), paste0("c", 1:10))
  )
  prc <- prcomp(matrix)
  hm <- chmNew("Demo PCA", matrix)
  hm <- chmAddPCA(hm, "column", prc)
}
}
\seealso{
\code{\link[=chmAddTSNE]{chmAddTSNE()}}

\code{\link[=chmAddUMAP]{chmAddUMAP()}}

\code{\link[=chmAddUWOT]{chmAddUWOT()}}

\code{\link[=chmAddReducedDim]{chmAddReducedDim()}}
}
