% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmAddUMAP}
\alias{chmAddUMAP}
\title{Add UMAP coordinates to an NG-CHM.}
\usage{
chmAddUMAP(hm, axis, umap, basename = "UMAP")
}
\arguments{
\item{hm}{The NGCHM to add the coordinates to.}

\item{axis}{The NGCHM axis ("row" or "column") to add the coordinates to.}

\item{umap}{TSNE coordinates (output of \href{https://CRAN.R-project.org/package=umap}{umap::umap()}) for the specified NGCHM axis.}

\item{basename}{The prefix to use for the coordinate names.}
}
\value{
The NGCHM with added coordinates.
}
\description{
Add UMAP coordinates as hidden covariate bars to an axis of an NG-CHM.  One hidden
covariate bar is added for each UMAP coordinate.  Coordinates have names 'BASENAME.coordinate.N',
where BASENAME is specified by the parameter basename (default UMAP) and N ranges from 1 to the number of
added covariate bars.
}
\examples{
# Examples using `chmNew()` require git to be installed.
\dontrun{
  # If the NGCHMDemoData package is installed, use it to demo usage
  if (requireNamespace("NGCHMDemoData", quietly = TRUE)) {
    data(TCGA.GBM.EXPR, package = "NGCHMDemoData")
    mat <- TCGA.GBM.EXPR[1:50, 1:50]
    umc <- umap::umap(t(mat))
    hm <- chmNew("gbm", mat)
    hm <- chmAddUMAP(hm, "column", umc)
  }
  # Small example not requiring NGCHMDemoData
  matrix <- matrix(rnorm(100),
    nrow = 10, ncol = 10,
    dimnames = list(paste0("r", 1:10), paste0("c", 1:10))
  )
  umc <- umap::umap(t(matrix), n_neighbors = 8)
  hm <- chmNew("Demo UMAP", matrix)
  hm <- chmAddUMAP(hm, "column", umc)
}

}
\seealso{
\code{\link[=chmAddPCA]{chmAddPCA()}}

\code{\link[=chmAddTSNE]{chmAddTSNE()}}

\code{\link[=chmAddUWOT]{chmAddUWOT()}}

\code{\link[=chmAddReducedDim]{chmAddReducedDim()}}
}
