% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_schedule.R
\name{wl_schedule}
\alias{wl_schedule}
\title{A simple operation scheduler}
\usage{
wl_schedule(
  waiting_list,
  schedule,
  referral_index = 1,
  removal_index = 2,
  unscheduled = FALSE
)
}
\arguments{
\item{waiting_list}{data.frame. A df of referral dates and removals}

\item{schedule}{vector of dates. Should be formatted as year-month-date, e.g.
"2024-04-01".  The dates to schedule open referrals into
(i.e. dates of unbooked future capacity)}

\item{referral_index}{integer. The column number in the waiting_list which
contains the referral dates}

\item{removal_index}{integer. The column number in the waiting_list which
contains the removal dates}

\item{unscheduled}{logical.
If TRUE, returns a list of scheduled and unscheduled procedures
If FALSE, only returns the updated waiting list}
}
\value{
The updated waiting list with removal dates assigned based on
the given schedule, either as a single \code{data.frame} (default) or as
part of a list (if \code{unscheduled = TRUE}).

If \code{unscheduled = TRUE}, returns a \code{list} with two data frames:
\enumerate{
\item A \code{data.frame}. The updated waiting list with scheduled removals.
\item A \code{data.frame} showing which slots were used, with columns:

\describe{
\item{schedule}{Date. The available dates from the input
\code{schedule}.}
\item{scheduled}{Numeric. \code{1} if the slot was used to schedule a
patient, \code{0} if not.}
}
}
}
\description{
Takes a list of dates and schedules them to a waiting list,
by adding a removal date to the data.frame.
This is done in referral date order,
I.e. earlier referrals are scheduled first (FIFO).
}
\examples{
referrals <- c.Date("2024-01-01", "2024-01-04", "2024-01-10", "2024-01-16")
removals <- c.Date("2024-01-08", NA, NA, NA)
waiting_list <- data.frame("referral" = referrals, "removal" = removals)
schedule <- c.Date("2024-01-03", "2024-01-05", "2024-01-18")
updated_waiting_list <- wl_schedule(waiting_list, schedule)

}
