% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual-cluster-in-bipartite.R
\name{visualClusterInBipartite}
\alias{visualClusterInBipartite}
\title{Plot the bipartite graph with color coding for different clusters in both parts}
\usage{
visualClusterInBipartite(
  data,
  community_left,
  community_right,
  name_left = "Left",
  name_right = "Right"
)
}
\arguments{
\item{data}{A data frame or matrix object as an edge list.}

\item{community_left}{An igraph community object, one projection of the bipartite network to be showed on the left side.}

\item{community_right}{An igraph community object, the other projection of the bipartite network to be showed on the right side.}

\item{name_left}{A string value, the name of left community.}

\item{name_right}{A string value, the name of right community.}
}
\value{
A customized Sankey plot with a data frame containing the cluster pairwise relationship with the sum of weight values in the weighted bipartite network.
}
\description{
The Sankey diagram is used to depict the connections between clusters within each part of the bipartite network. The display is also interactive, and by grouping nodes within each cluster as "summary" nodes, this function emphasizes how clusters of each part are connected together.
}
\examples{
# load part of the beatAML data
beatAML_data <- NIMAA::beatAML[1:1000,]

# convert to incidence matrix
beatAML_incidence_matrix <- el2IncMatrix(beatAML_data)

# extract the Recetengular_element_max submatrix
sub_matrices <- extractSubMatrix(beatAML_incidence_matrix,
col.vars = "patient_id", row.vars = "inhibitor",
shape = c("Rectangular_element_max"))

# do clustering analysis
cls1 <- findCluster(sub_matrices$Rectangular_element_max,
part = 1, comparison = FALSE)

cls2 <- findCluster(sub_matrices$Rectangular_element_max,
part = 2, comparison = FALSE)

visualClusterInBipartite(data = beatAML_data,
community_left = cls2$leading_eigen,
community_right = cls1$fast_greedy,
name_left = 'patient_id',
name_right = 'inhibitor')
}
\seealso{
\code{\link[plotly]{plot_ly}}
}
