% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_manual_edit.R
\name{apply_manual_edit}
\alias{apply_manual_edit}
\title{Apply a manual edit patch}
\usage{
apply_manual_edit(m, patch_id, return_merge_conf_ctl = FALSE)
}
\arguments{
\item{m}{An nm object.}

\item{patch_id}{Character name of patch.  Corresponds to the file name in
the "patches" subdirectory of \code{nm_dir("models")}.}

\item{return_merge_conf_ctl}{Logical (default = \code{FALSE}). If there a merge
conflict produced, should the ctl file be returned?}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

It is best to allow the "manual edit" RStudio 'Addin' to write this function
in your script for you.  After a tracked manual edit is performed, a patch
file is created and saved in the "patches" subdirectory of
\code{nm_dir("models")}.  This function applies the patch to the object.
}
\details{
Generally best to to apply patches before automatic edits and
changes in directories e.g. via \code{run_in()}.  If patches are applied to
NONMEM control file sections that are likely to change in the future, the
patch may fail to apply.  In this case, it is best to view the patch (via
the "view patch" RStudio 'Addin') and manually re-implement the changes again
in a new manual edit.
}
