% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-code.R
\name{import}
\alias{import}
\title{Import staged files into project}
\usage{
import(
  copy_table,
  overwrite = FALSE,
  silent = FALSE,
  skip = "\\\\.mod$",
  find_replace_dir_names = TRUE
)
}
\arguments{
\item{copy_table}{A \verb{data frame} or character. if \code{data.frame} should be
output from \code{stage()}, if character path, result will be \code{stage()}d first.}

\item{overwrite}{Logical (default = \code{FALSE}).}

\item{silent}{Logical (default = \code{FALSE}).}

\item{skip}{Character (default = \code{"\\\\.mod$"}). Pattern to skip.  Model files
will be imported directly into the project in order to avoid conflicts and
will instead reside only in the staging area.}

\item{find_replace_dir_names}{Logical (default = TRUE). Will attempt to find
replace strings in scripts to reflect \code{\link[=nm_default_dirs]{nm_default_dirs()}}.}
}
\value{
Invisibly returns \code{copy_table} argument.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function is used by the "code libary" RStudio 'Addin' to bring external
code into your project.
}
\examples{

## requires NMproject directory structure
\dontrun{

## both of these following operations are easier in the shiny code library
## RStudio 'Addin'.

ls_code_library("Models/ADVAN2.mod") \%>\%
  import() ## ends up in "staging/Models"

ls_code_library("Scripts/AUC.R") \%>\%
  import() ## ends up "scripts" directory
}

}
\seealso{
\code{\link[=code_library]{code_library()}}, \code{\link[=stage]{stage()}}
}
