% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic-ctl-manipulation.R
\name{fill_input}
\alias{fill_input}
\title{Fill $INPUT}
\usage{
fill_input(m, ...)
}
\arguments{
\item{m}{An nm object.}

\item{...}{Either \code{keep}, \code{drop}, or \code{rename} arguments.  See examples.}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Uses dataset to automatically fill $INPUT in control file.
}
\details{
If a new dataset with different columns is assigned to an \code{nm}
object, \verb{$INPUT} will not be correct and so it may necessary to apply
\code{fill_input()} again.

See examples for how to use \code{drop} and \code{rename} arguments to control how
\verb{$INPUT} is written.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 \%>\% dollar("INPUT") ## shows placeholder for column names

m1 <- m1 \%>\% fill_input()
m1 \%>\% dollar("INPUT") ## view $INPUT

## following will will drop the "RATE" column
m1 <- m1 \%>\% fill_input(drop = "RATE")
## no RATE column so will not drop anything
m1 \%>\% dollar("INPUT") 

## following will rename "DATE" to be "DAT0"
m1 <- m1 \%>\% fill_input(rename = c("DAT0" = "DATE"))
## no DATE column so will not rename anything
m1 \%>\% dollar("INPUT") ## view $INPUT

}
