% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNS_term_matrix.R
\name{NNS.term.matrix}
\alias{NNS.term.matrix}
\title{NNS Term Matrix}
\usage{
NNS.term.matrix(x, oos = NULL)
}
\arguments{
\item{x}{Text A two column dataset should be used.  Concatenate text from original sources to comply with format.  Also note the possiblity of factors in \code{"DV"}, so \code{"as.numeric(as.character(...))"} is used to avoid issues.}

\item{oos}{Out-of-sample text dataset to be classified}
}
\value{
Returns the text as independent variables \code{"IV"} and the classification as the dependent variable \code{"DV"}.  Out-of-sample independent variables are returned with \code{"OOS"}.
}
\description{
Generates a term matrix for text classification use in \link{VN.reg}.
}
\examples{
x<- data.frame(cbind(c("sunny","rainy"),c(1,-1)))
NNS.term.matrix(x)

### Concatenate Text with space seperator, cbind with "DV"
x<- data.frame(cbind(c("sunny","rainy"),c("windy","cloudy"),c(1,-1)))
x<- data.frame(cbind(paste(x[,1],x[,2],sep=" "),as.numeric(as.character(x[,3]))))
NNS.term.matrix(x)
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}

