% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dy_dx.R
\name{dy.dx}
\alias{dy.dx}
\title{Partial Derivative dy/dx}
\usage{
dy.dx(x, y, order = NULL, s.t.n = 0.9, eval.point = median(x),
  deriv.order = 1, h = 0.05, noise.reduction = NULL)
}
\arguments{
\item{x}{Independent Variable}

\item{y}{Dependent Variable}

\item{order}{Controls the number of partial moment quadrant means.  Defaults to NULL to allow \link{VN.reg} to determine optimal order based on R2 of regression.  \code{order='max'} generates a more accurate derivative for well specified cases.}

\item{s.t.n}{Signal to noise parameter, sets the threshold of \code{VN.dep} which reduces \code{"order"} when \code{order=NULL}.  Defaults to 0.9 to ensure high dependence for higher \code{"order"} and endpoint determination.}

\item{eval.point}{Independent variable point to be evaluated.  Defaults to \code{median(x)}.}

\item{deriv.order}{For second derivative estimate of \code{f(x)}, set \code{deriv.order=2}.  Defaults to first derivative.}

\item{h}{Percentage step used for finite step method.  Defaults to \code{h=.05} representing a 5 percent step from the value of the independent variable.}

\item{noise.reduction}{In low signal:noise situations, \code{noise.reduction="median"} uses medians instead of means for partitions, while \code{noise.reduction="mode"} uses modes instead of means for partitions.  \code{noise.reduction=NULL}  (Default setting) allows for maximum possible fit in \link{VN.reg}.}
}
\value{
Returns the value of the partial derivative estimate for the given order.
}
\description{
Returns the numerical partial derivate of y wrt x for a point of interest.
}
\examples{
x<-seq(0,2*pi,pi/100); y<-sin(x)
dy.dx(x,y,eval.point=1.75)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{derivative,}
\keyword{nonlinear}
\keyword{partial}
\keyword{regression}

